unit LexSampleU;

interface

uses
  SysUtils,
  Windows,
  Messages,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  Buttons,
  ExtCtrls,
  StdCtrls,
  Menus,
{$IFDEF CLR}
  System.Data,
  System.Windows.Forms,
  System.Text,
  System.ComponentModel,
{$ENDIF}
{$IFDEF MSWINDOWS}
  mwStringStream,
{$ENDIF}
  mwDelphiLanguageElements,
  mwDelphiParser,
  mwIdToString;

type
  TLexSampleForm = class(TForm)
    SamplePanel: TPanel;
    btnPerformance: TButton;
    btnTokenSample: TButton;
    SampleMemo: TMemo;
    OpenDialog1: TOpenDialog;
    procedure btnPerformanceClick(Sender: TObject);
    procedure btnTokenSampleClick(Sender: TObject);
  private
    Stream: TMemoryStream;
    Parser: TmwDelphiParser;
    Start, Stop, Frequency: TLargeInteger;
    Elapsed: Extended;
  public
    { Public declarations }
  end;

  TmwString = array of AnsiChar;
var
  LexSampleForm: TLexSampleForm;

implementation

{$R *.dfm}

procedure TLexSampleForm.btnPerformanceClick(Sender: TObject);
begin
  if OpenDialog1.Execute then
  begin
    Stream := TMemoryStream.Create;
    Parser := TmwDelphiParser.Create;
    Stream.LoadFromFile(OpenDialog1.FileName);
{$IFDEF CLR}
    Parser.SetBuf(TmwString(Stream.Memory));
{$ELSE}
    Parser.SetBuf(Stream.Memory, Stream.Size);
{$ENDIF}
    QueryPerformanceFrequency(Frequency);
    QueryPerformanceCounter(Start);
    while Parser.Id <> leAtEnd do
    Parser.NextToken;
    QueryPerformanceCounter(Stop);
    Elapsed := (Stop - Start) / Frequency;
    Caption := FloatToStr(Elapsed);
    Stream.Free;
    Parser.Free;
  end;
end;

procedure TLexSampleForm.btnTokenSampleClick(Sender: TObject);
var
{$IFDEF CLR}
  OutBuf: StringBuilder;
{$ELSE}
  OutBuf: TmwStringStream;
{$ENDIF}
  NrString, TokenStr, IdStr, Space, LE: string;
begin
  if OpenDialog1.Execute then
  begin
    Stream := TMemoryStream.Create;
    Parser := TmwDelphiParser.Create;
    LE := #13#10;
    Space := '   ';
    Stream.LoadFromFile(OpenDialog1.FileName);
{$IFDEF CLR}
    OutBuf := StringBuilder.Create(Stream.Size * 4);
    Parser.SetBuf(TmwString(Stream.Memory));
{$ELSE}
    OutBuf := TmwStringStream.Create('');
    Parser.SetBuf(Stream.Memory, Stream.Size);
{$ENDIF}
    Stream.LoadFromFile(OpenDialog1.FileName);
    while Parser.Id <> leAtEnd do
    begin
      NrString := IntToStr(Parser.LineNumber) + '   ';
{$IFDEF CLR}
      TokenStr := Parser.WideToken;
{$ELSE}
      TokenStr := Parser.Token;
{$ENDIF}
      if Parser.Id = leIdentifier then
      begin
        if Parser.ExId <> leUnknown then
          IdStr := IdToString(Parser.ExId)
        else
          IdStr := IdToString(Parser.Id);
      end else IdStr := IdToString(Parser.Id);
{$IFDEF CLR}
      OutBuf.Append(LE);
      OutBuf.Append(NrString);
      OutBuf.Append(TokenStr);
      OutBuf.Append(Space);
      OutBuf.Append(IdStr);
{$ELSE}
      OutBuf.WriteString(LE);
      OutBuf.WriteString(NrString);
      OutBuf.WriteString(TokenStr);
      OutBuf.WriteString(Space);
      OutBuf.WriteString(IdStr);
{$ENDIF}
      Parser.NextToken;
    end;
    Caption := '';
    SampleMemo.Lines.BeginUpdate;
    SampleMemo.Clear;
{$IFDEF CLR}
    SampleMemo.Text := OutBuf.ToString;
{$ELSE}
    SampleMemo.Text := OutBuf.DataString;
{$ENDIF}
    SampleMemo.Lines.EndUpdate;
    Stream.Free;
    Parser.Free;
    OutBuf.Free;
  end;
end;

end.

